#
# Written by:
# -- 
# John L. Weatherwax                2009-04-21
# 
# email: wax@alum.mit.edu
# 
# Please send comments and especially bug reports to the
# above email address.
# 
#-----

#postscript("../WriteUp/Graphics/1960/prob_34.eps", onefile=FALSE, horizontal=FALSE)

n = 1000
ts = seq(0, 180, length.out=n)

## Plot x_A(t):
##
xA = rep(NA, n)

tMask = (0 <= ts) & (ts <= 30)
tr = ts[tMask]
xA[tMask] = 3*tr

tMask = (ts > 30) & (ts <= 60)
tr = ts[tMask]
xA[tMask] = 180 - 3*tr

tMask = (ts > 60) & (ts <= 90)
tr = ts[tMask]
xA[tMask] = 3*tr - 180

tMask = (ts > 90) & (ts <= 120)
tr = ts[tMask]
xA[tMask] = 360 - 3*tr

tMask = (ts > 120) & (ts <= 150)
tr = ts[tMask]
xA[tMask] = 3*tr - 360

tMask = (ts > 150) & (ts <= 180)
tr = ts[tMask]
xA[tMask] = 540 - 3*tr


## Plot x_B(t):
##
xB = rep(NA, n)

tMask = (0 <= ts) & (ts <= 45)
tr = ts[tMask]
xB[tMask] = 90 - 2*tr

tMask = (ts > 45) & (ts <= 90)
tr = ts[tMask]
xB[tMask] = 2*tr - 90

tMask = (ts > 90) & (ts <= 135)
tr = ts[tMask]
xB[tMask] = 270 - 2*tr

tMask = (ts > 135) & (ts <= 180)
tr = ts[tMask]
xB[tMask] = 2*tr - 270

plot(ts, xA, 'l', col='red', xlab='time', ylab='position')
lines(ts, xB, 'l', col='blue')
grid()

legend('bottomright', c('swimmer A', 'swimmer B'), col=c('red', 'blue'), lty=c(1, 1))

#dev.off() 
