draw_region = function(a){
    #
    # Draws the region suggested by the given inequalities.
    #
    stopifnot( a>0 )

    # Draw the lines first:
    #
    x = seq( -2*a, +3*a, length.out=100 )

    y = a - x
    plot( x, y, type='l', col='blue')

    y = x + a
    lines( x, y, type='l', col='red' )

    y = x - a
    lines( x, y, type='l', col='green' )

    abline(v=a/2, col='black')
    abline(v=2*a, col='black')
    
    abline(h=a/2, col='black')
    abline(h=2*a, col='black')

    polygon(x=c(a/2, a/2, a, 2*a, 2*a, 3*a/2), y=c(a/2, 3*a/2, 2*a, 2*a, a, a/2), col='gray')
    points(x=c(a/2, a/2, a, 2*a, 2*a, 3*a/2), y=c(a/2, 3*a/2, 2*a, 2*a, a, a/2), col='black', pch=19)

    # Draw the axis with thicker lines:
    abline(v=0, col='black', lwd=3)
    abline(h=0, col='black', lwd=3)

    grid()
    title(sprintf('a=%.0f', a))
}

#postscript("../WriteUp/Graphics/1978/prob_25.eps", onefile=FALSE, horizontal=FALSE)

draw_region( 4 )

#dev.off()
