#!/usr/bin/env python
#
import numpy as np

# Sets of the coefficients "k" of the arguments cos(k x) in the expansion of P_m for 1 <= m <= 10:
#
Cos_Coeffs = {}
Cos_Coeffs[1] = np.asarray([1])
for n in range(2, 10+1):
    ns = np.hstack((np.abs(Cos_Coeffs[n-1] - n), Cos_Coeffs[n-1] + n))
    Cos_Coeffs[n] = np.asarray(sorted(set(ns)))
    #print(f'n= {n}; P_n arguments are {Cos_Coeffs[n]}')
    if 0 in Cos_Coeffs[n]:
       print(f'P_{n} has a zero in the set S_{n}')
