#!/usr/bin/env python
#
import numpy as np

import itertools; from itertools import product

for large_cube_side_length in [3, 4, 5]:
    items = np.arange(0, large_cube_side_length)
    corners = product(items, items, items)

    number_split_cubes = 0
    for c in corners:
        base_cubes_side = np.sign(c[0] + c[1] + c[2] - 3*large_cube_side_length/2) # what side of the plane is the corner on?
        offsets = product(np.arange(0, 2), np.arange(0, 2), np.arange(0, 2))
        for of in offsets:
            pt = np.asarray(c) + np.asarray(of)
            pt_side = np.sign(pt[0] + pt[1] + pt[2] - 3*large_cube_side_length/2) # what side of the plane is this point in this cube on?
            if np.sign(base_cubes_side*pt_side)!=1:
                number_split_cubes += 1
                break
    print(f'large_cube_side_length= {large_cube_side_length:4d}; number_split_cubes= {number_split_cubes} from total_sucubes= {large_cube_side_length**3:5d}')
