import copy
import math
import numpy as np

from fractions import Fraction

def all_quotients(lst):
    """
    """
    if len(lst)==1:
        return [lst[0]]
    elif len(lst)==2:
        return [Fraction(lst[0], lst[1])]
    else:
        n = len(lst)
        ans = []
        for ii in range(n-1):
            # Divide lst[ii] / lst[ii+l]:
            f = Fraction(lst[ii], lst[ii+1])
            new_lst = copy.copy(lst)
            del new_lst[ii+1]
            new_lst[ii] = f
            ans += all_quotients(new_lst)
        return ans

if __name__=='__main__':
    """
    """
    lst = [1, 2]
    nq = math.factorial(len(lst)-1)
    res = all_quotients(lst)
    print(f'len(lst)= {len(lst):4d}; n_quotients= {nq:10d}; res({len(res):10d})= {res}')
    print(f'min(res)= {min(res)}; max(res)= {max(res)}')
    int_lst = [_ for _ in res if _.denominator == 1]
    print(f'ints in lst= {int_lst}')

    lst = [1, 2, 3]
    nq = math.factorial(len(lst)-1)
    res = all_quotients(lst)
    print(f'len(lst)= {len(lst):4d}; n_quotients= {nq:10d}; res({len(res):10d})= {res}')
    print(f'min(res)= {min(res)}; max(res)= {max(res)}')
    int_lst = [_ for _ in res if _.denominator == 1]
    print(f'ints in lst= {int_lst}')

    lst = [1, 2, 3, 4]
    nq = math.factorial(len(lst)-1)
    res = all_quotients(lst)
    print(f'len(lst)= {len(lst):4d}; n_quotients= {nq:10d}; res({len(res):10d})= {res}')
    print(f'min(res)= {min(res)}; max(res)= {max(res)}')
    int_lst = [_ for _ in res if _.denominator == 1]
    print(f'ints in lst= {int_lst}')

    lst = list(range(1, 12))
    nq = math.factorial(len(lst)-1)
    res = all_quotients(lst)
    print(f'len(lst)= {len(lst):4d}; n_quotients= {nq:10d}; res({len(res):10d})[:100]= {str(res)[:100]}')
    print(f'min(res)= {min(res)}; max(res)= {max(res)}')
    int_set = set([_ for _ in res if _.denominator == 1])
    print(f'ints in lst= {str(int_set)[:100]}')
    print(f'min(int_set)= {min(int_set)}; max(int_set)= {max(int_set)}')
