#!/usr/bin/env python
#
import numpy as np
import matplotlib
matplotlib.use('TkAgg')
import matplotlib.pyplot as plt

def f(x):
    return 1/(x - 2009) + 1/(x - 2010) + 1/(x - 2011)

x = np.linspace(2007, 2017, 1000)
mask = (x != 2009) & (x != 2010) & (x != 2011)
x = x[mask]
y = f(x)

plt.figure(figsize=(7, 4))
plt.plot(x, y, color='tab:blue', lw=2)

# horizontal lines
plt.axhline(0, color='black', lw=1)
plt.axhline(1, color='tab:orange', lw=1.5, linestyle='-', label='y = 1')

# vertical red lines at the singularities
for year in [2009, 2010, 2011]:
    plt.axvline(year, color='red', lw=1.5)

plt.ylim(-5, 5)
#plt.title(r"$f(x) = \frac{1}{x - 2009} + \frac{1}{x - 2010} + \frac{1}{x - 2011}$")
plt.xlabel("x")
plt.ylabel("f(x)")
plt.legend()
plt.grid(True, linestyle="--", alpha=0.5)
plt.tight_layout()
plt.show()
