from itertools import product
import pandas as pd

if __name__ == '__main__':
    # Consider possible different values for a−2 (a factor of 1260):
    #
    # 2^[0, 1, 2] * 3^[0, 1, 2] * 5^[0, 1] * 7^[0, 1]
    #
    results = []
    for powers in product(range(3), range(3), range(2), range(2)):
        a_minus_2 = 2**powers[0] * 3**powers[1] * 5**powers[2] * 7**powers[3]
        a_plus_3 = a_minus_2 + 5
        m = (1260 / a_minus_2) / a_plus_3  # what is the integer m?
        if m.is_integer():
            results.append((a_minus_2, a_plus_3))

    df = pd.DataFrame(results, columns=['a_minus_2', 'a_plus_3'])
    df = df.sort_values('a_minus_2', ascending=True).reset_index(drop=True)
    df['a'] = df['a_minus_2'] + 2
    df['m'] = 1260 // (df['a_minus_2'] * df['a_plus_3'])
    print(df)
