from itertools import product
import pandas as pd

if __name__ == '__main__':
    ## Consider possible different values for the factors of 12:
    # 2^[0, 1, 2] * 3^[0, 1]
    results = []

    for powers in product(range(3), range(2)):
        p = 2**powers[0] * 3**powers[1]
        q = 12 // p

        # Both factors p and q must be even or odd for x and y to be integers:
        both_even = (p % 2 == 0) and (q % 2 == 0)
        both_odd  = (p % 2 == 1) and (q % 2 == 1)

        if both_even or both_odd: results += [(p, q), (-p, -q)]

    df = pd.DataFrame(results, columns='p q'.split())
    df['x'] = (df['q'] + df['p']) // 2
    df['y'] = (df['q'] - df['p']) // 2
    df = df.sort_values('x y'.split(), ascending=True).reset_index(drop=True)

    print(df)
