from itertools import product
import pandas as pd

if __name__ == '__main__':
    ## Consider possible different values for the factors of 81:
    # 3^[0, 1, 2, 3, 4]
    results = []

    for power in range(5):
        p = 3**power
        q = 81 // p

        # Both factors p and q must be even or odd for x and y to be integers:
        both_even = (p % 2 == 0) and (q % 2 == 0)
        both_odd  = (p % 2 == 1) and (q % 2 == 1)

        if both_even or both_odd: results.append((p, q))

    df = pd.DataFrame(results, columns='p q'.split())
    df['x'] = (df['q'] + df['p']) // 2
    df['y'] = (df['q'] - df['p']) // 2

    mask = (df['x'] > 0) & (df['y'] > 0)
    df = df[mask].reset_index(drop=True)
    df = df.sort_values('x y'.split(), ascending=True).reset_index(drop=True)
    print(df)

    x, y = 15, 12  # one solution printed above
    z, w = 41, 40  # the other solution printed above

    print(x*z + y*w + x*w + y*z)
