from itertools import product
import numpy as np
import pandas as pd

if __name__ == '__main__':
    ## Consider possible different values for the factors of 15:
    # 3^[0, 1] * 5^[0, 1]
    results = []

    for powers in product(range(2), range(2)):
        x = 3**powers[0] * 5**powers[1]  # <- a factor of 15
        for sign_of_x in [1, -1]:
            x *= sign_of_x
            if x == -1: continue

            y = (15 // x + 3) / (2 * (x + 1))
            if y == 0: continue
            if not float(y).is_integer(): continue

            results.append((x, int(y)))

    df = pd.DataFrame(results, columns='x y'.split()).sort_values('x y'.split(), ascending=True).reset_index(drop=True)
    print(df)
