from itertools import product
import numpy as np
import pandas as pd

if __name__ == '__main__':
    ## Consider possible different values for the factors of 42:
    # 2^[0, 1] * 3^[0, 1] * 7^[0, 1]
    results = []

    for powers in product(range(2), range(2), range(2)):
        y = 2**powers[0] * 3**powers[1] * 7**powers[2]  # <- a factor of 42
        x = 9 - 42 // y
        if x < 0: continue
        if not float(x).is_integer(): continue
        results.append((y, int(x)))

    df = pd.DataFrame(results, columns='y x'.split())
    df = df['x y'.split()].sort_values('x', ascending=True).reset_index(drop=True)
    print(df)
