from itertools import product
import numpy as np
import pandas as pd

if __name__ == '__main__':
    ## Consider possible different values for the factors of 96:
    # 2^[0, 1, 2, 3, 4, 5] * 3^[0, 1]
    results = []

    for powers in product(range(6), range(2)):
        y_plus_12 = 2**powers[0] * 3**powers[1]  # <- a factor of 96
        y = y_plus_12 - 12
        if y <= 0: continue

        x = 8 - 96 // y_plus_12
        if x <= 0: continue
        if not float(x).is_integer(): continue

        results.append((y, int(x)))

    df = pd.DataFrame(results, columns='y x'.split())
    df = df['x y'.split()].sort_values('x y'.split(), ascending=True).reset_index(drop=True)
    print(df)
