import numpy as np
import pandas as pd

if __name__ == '__main__':
    if False:
        # Polynomial: x^3 - 6x^2 + 11x - 6 = 0
        coeffs = [1, -6, 11, -6]  # coefficients in descending order
        roots = np.roots(coeffs)
        print(roots)

    print('4 + 12 y - 3 y^2 = 0 when y= ')
    coeffs = [-3, 12, 4]
    roots = np.roots(coeffs)
    print(sorted(np.round(roots, 6)))

    # Integers in that range are:
    y_choices = np.arange(0, 5)
    results = []

    for y in y_choices:
        delta = 4 + 12*y - 3*y**2  # <- this must be a perfect square
        sqrt_delta = np.sqrt(delta)
        if not float(sqrt_delta).is_integer(): continue

        coeffs = [1, -(2 + y), y**2 - 2*y]
        xs = np.sort(np.roots(coeffs).astype(int))

        for x in xs:
            #print(f'y={y:4d}; delta={delta:4d}; x={x:4d}')
            results.append((x, y))

    df = pd.DataFrame(results, columns='x y'.split())
    df = df.sort_values(['x', 'y'], ascending=True).reset_index(drop=True)
    print(df)
