import sympy as sp

# Define symbols
x, y = sp.symbols('x y')

# Define your expression
expr = 4*x**3 + (4*y - 12)*x**2 + (-15*y**2 + 6*y + 5)*x + (-18*y**3 + 36*y**2 - 10*y)

# Substitute x = 2 and simplify
expr_xy = expr.subs(x, 2)
expr_simplified = sp.simplify(expr_xy)

print("Expression after substituting x = 2:")
sp.pretty_print(expr_simplified)

# Substitute x = y and simplify
expr_xy = expr.subs(x, y)
expr_simplified = sp.simplify(expr_xy)

print("Expression after substituting x = y:")
sp.pretty_print(expr_simplified)

# Substitute x = 3 y - 1 and simplify
expr_xy = expr.subs(x, 3*y-1)
expr_simplified = sp.simplify(expr_xy)

print("Expression after substituting x = 3y - 1:")
sp.pretty_print(expr_simplified)

# Substitute x = 3 y - 5 and simplify
expr_xy = expr.subs(x, 3*y-5)
expr_simplified = sp.simplify(expr_xy)

print("Expression after substituting x = 3y - 5:")
sp.pretty_print(expr_simplified)

# Substitute x = 2 y and simplify
expr_xy = expr.subs(x, 2*y)
expr_simplified = sp.simplify(expr_xy)

print("Expression after substituting x = 2 y:")
sp.pretty_print(expr_simplified)

## After one deflation:
#
expr = 4*x**2 + 12*(y-1)*x + 9*y**2 - 18*y + 5

# Substitute x = 3 y - 1 and simplify
expr_xy = expr.subs(x, -(3*y - 1)/2)
expr_simplified = sp.simplify(expr_xy)

print("Expression after substituting x = -(3 y - 1)/2:")
sp.pretty_print(expr_simplified)


