from itertools import product
import numpy as np
import pandas as pd

if __name__ == '__main__':
    ## Consider possible different values for the factors of 17404:
    #
    N = 17404
    sqrt_N = np.sqrt(N)
    results = []

    for powers in product(range(3), range(2), range(2)):
        a = 2**powers[0] * 19**powers[1] * 229**powers[2]
        if a > sqrt_N: continue  # <- only go halfway we need a < b
        b = N // a

        # Both factors a and b must be even or odd:
        both_even = (a % 2 == 0) and (b % 2 == 0)
        both_odd  = (a % 2 == 1) and (b % 2 == 1)
        if not (both_even or both_odd): continue

        n = (b - a) / 2
        p = (a + b + 264) / 10
        if not float(p).is_integer(): continue
        if p < 53: continue

        results.append((a, b, int(p), int(n)))

    df = pd.DataFrame(results, columns='a b p n'.split())
    df = df.sort_values('a', ascending=True).reset_index(drop=True)
    print(df)
